<?php

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') exit;

$uploadDir = __DIR__ . '/media/';
is_dir($uploadDir) || mkdir($uploadDir, 0755, true);

function genName(string $ext = 'png', int $len = 6): string {
    return substr(bin2hex(random_bytes($len)), 0, $len) . ".$ext";
}

function fileUrl(string $file): string {
    $https = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off');
    $protocol = $https ? 'https://' : 'http://';
    $host = $_SERVER['HTTP_HOST'];
    $path = str_replace('\\', '/', realpath(__DIR__ . '/media/' . $file));
    $doc = str_replace('\\', '/', realpath($_SERVER['DOCUMENT_ROOT']));
    $rel = str_replace($doc, '', $path);
    return $protocol . $host . $rel;
}

$img = $_GET['img'] ?? null;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $ct = $_SERVER['CONTENT_TYPE'] ?? '';
    if (str_contains($ct, 'application/json')) {
        $json = json_decode(file_get_contents('php://input'), true);
        $img = $json['img'] ?? $img;
    } else {
        $img = $_POST['img'] ?? $img;
    }
}

if (!$img || !filter_var($img, FILTER_VALIDATE_URL)) {
    echo json_encode(['ok' => false, 'dev' => '@OnyxApiTeam', 'result' => 'Invalid or missing img'], JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
    exit;
}

$tmp = $uploadDir . genName('jpg', 4);
$data = @file_get_contents($img);
if (!$data) {
    echo json_encode(['ok' => false, 'dev' => '@OnyxApiTeam', 'result' => 'Failed to download image'], JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
    exit;
}
file_put_contents($tmp, $data);

$ch = curl_init('https://app.hooshbox.ir/api/apps/api/v1/demo_enhancer');
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => [
        'file_img' => new CURLFile($tmp, 'image/jpeg', basename($tmp)),
        'only_face' => 'false',
        'upscale' => '2',
    ],
    CURLOPT_HTTPHEADER => ['accept: application/*']
]);
$res = curl_exec($ch);
$code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);
unlink($tmp);

if ($code === 200 && $res) {
    $out = $uploadDir . genName();
    file_put_contents($out, $res);
    $url = fileUrl(basename($out));
    echo json_encode(['ok' => true, 'dev' => '@OnyxApiTeam', 'result' => $url], JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);

    ignore_user_abort(true);
    set_time_limit(0);
    function_exists('fastcgi_finish_request') && fastcgi_finish_request();

    $fileRealPath = realpath($out);
    exec("php -r 'sleep(30); @unlink(\"$fileRealPath\");' > /dev/null 2>&1 &");
    exit;
}

echo json_encode(['ok' => false, 'dev' => '@OnyxApiTeam', 'result' => 'Failed', 'http_code' => $code], JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
