<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

class VajehyabAPI {
    private $baseUrl = "https://engine.vajehyab.com/search";
    private $allowedScopes = ['all', 'exact', 'similar', 'homophone', 'spell', 'spells', 'text', 'prefix', 'suffix'];
    private $allowedDicts = [
        'wiki', 'motaradef', 'en2fa', 'fa2en', 'teyfi', 'thesis', 'dehkhoda', 'moein', 'amid', 'name', 'sereh',
        'farhangestan', 'quran', 'ganjvajeh', 'brand', 'dezfuli', 'khalkhal', 'kermanshah', 'tehrani', 'mazani',
        'bakhtiari', 'gonabadi', 'isfahani', 'ar2fa', 'fa2tr', 'fa2ar'
    ];
    private $dev = "@OnyxApiTeam";

    private function getRequestParam($key) {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST[$key])) {
                return $_POST[$key];
            }
            $input = file_get_contents('php://input');
            $data = json_decode($input, true);
            if (is_array($data) && isset($data[$key])) {
                return $data[$key];
            }
        }
        return $_GET[$key] ?? null;
    }

    public function run() {
        $query = trim($this->getRequestParam('search') ?? '');
        if ($query === '') {
            $this->sendResponse(false, "پارامتر //search// اجباری است.");
            return;
        }

        $scope = strtolower(trim($this->getRequestParam('scope') ?? 'all'));
        if (!in_array($scope, $this->allowedScopes)) {
            $scope = 'all';
        }
        if ($scope === 'all') {
            $scope = '';
        }

        $dictRaw = strtolower(trim($this->getRequestParam('d') ?? ''));
        $dict = '';
        if ($dictRaw !== '') {
            $dicts = explode(',', $dictRaw);
            $dicts = array_map('trim', $dicts);
            $dicts = array_filter($dicts, function($d) {
                return in_array($d, $this->allowedDicts);
            });
            $dict = implode(',', $dicts);
        }

        $params = [
            'q' => $query,
            's' => $scope,
            'l' => 20,
            'o' => 0,
        ];
        if ($dict !== '') {
            $params['d'] = $dict;
        }

        $url = $this->baseUrl . '?' . http_build_query($params);

        $response = $this->curlGet($url);
        if ($response === false) {
            $this->sendResponse(false, "خطا در دریافت پاسخ از سرویس واژه یاب.");
            return;
        }

        $json = json_decode($response, true);
        if ($json === null) {
            $this->sendResponse(false, "خطا در پردازش پاسخ از سرویس واژه یاب.");
            return;
        }

        $this->sendResponse(true, null, $json);
    }

    private function curlGet(string $url) {
        $ch = curl_init($url);
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_TIMEOUT => 5,
            CURLOPT_USERAGENT => 'VajehyabAPI/1.0',
        ]);
        $result = curl_exec($ch);
        curl_close($ch);
        return $result;
    }

    private function sendResponse(bool $ok, ?string $errorMsg = null, $data = null) {
        $out = [
            'ok' => $ok,
            'dev' => $this->dev,
        ];
        if ($ok) {
            $out['data'] = $data;
        } else {
            $out['error'] = $errorMsg ?? "خطای نامشخص";
        }
        echo json_encode($out, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    }
}

$api = new VajehyabAPI();
$api->run();
