<?php

error_reporting(0);
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

function randIP() {
    return implode('.', [mt_rand(1, 255), mt_rand(0, 255), mt_rand(0, 255), mt_rand(1, 254)]);
}

function sendRequest($url, $data) {
    $ip = randIP();
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_HTTPHEADER => [
            'Content-Type: application/json',
            'CLIENT-IP: ' . $ip,
            'X-FORWARDED-FOR: ' . $ip
        ],
        CURLOPT_POSTFIELDS => json_encode($data)
    ]);
    $res = curl_exec($ch);
    curl_close($ch);
    return json_decode($res, true);
}

$input = $_GET ?: ($_POST ?: json_decode(file_get_contents('php://input'), true) ?: []);

if (empty($input['text'])) {
    echo json_encode([
        'ok'    => false,
        'dev'   => '@Cactus_Dev',
        'error' => 'Missing required parameter: text'
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    exit;
}

$text = trim($input['text']);

$task = sendRequest('https://tool-api.vidnoz.com/ai/ai-tool/add-task', [
    'action' => 'image_text_to_video',
    'param'  => [
        'key'            => '',
        'text'           => $text,
        'resolution_id'  => '150',
        'style_id'       => ''
    ]
]);

if (empty($task['data']['task_id'])) {
    echo json_encode([
        'ok'    => false,
        'dev'   => '@Cactus_Dev',
        'error' => $task['message'] ?? 'Failed to create task'
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    exit;
}

$taskId = $task['data']['task_id'];

for ($i = 0; $i < 60; $i++) {
    sleep(5);
    $check = sendRequest('https://tool-api.vidnoz.com/ai/tool/get-task', ['id' => $taskId]);
    
    if (!isset($check['data'])) {
        echo json_encode([
            'ok'    => false,
            'dev'   => '@Cactus_Dev',
            'error' => $check['message'] ?? 'Failed to fetch task'
        ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
        exit;
    }

    $d = $check['data'];

    if ($d['status'] == 0 && $d['progress'] == 100) {
        echo json_encode([
            'ok'     => true,
            'dev'    => '@Cactus_Dev',
            'result' => $d['additional_data']['video_url'] ?? null
        ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
        exit;
    }
}

echo json_encode([
    'ok'    => false,
    'dev'   => '@Cactus_Dev',
    'error' => 'Timeout waiting for video generation'
], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
