<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');

error_reporting(0);
ini_set('display_errors', 0);

$config = require 'config.php';
require_once 'lib/AudioManager.php';
require_once 'lib/AIManager.php';

$allowed_voices = $config['allowed_voices'] ?? ($config['gemini']['allowed_voices'] ?? []);

function jsonResponse($ok, $data = [], $error = null) {
    $response = ['ok' => $ok, 'dev' => '@OnyxApiTeam'];
    if ($ok) $response = array_merge($response, $data);
    if (!$ok && $error) $response['error'] = $error;
    echo json_encode($response, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    exit;
}

if (isset($_POST['prompt']) || isset($_POST['userid']) || isset($_POST['userId']) || isset($_POST['model'])) {
    $prompt = $_POST['prompt'] ?? null;
    $userId = $_POST['userid'] ?? $_POST['userId'] ?? null;
    $voice  = $_POST['model'] ?? null;
} else {
    $prompt = $_GET['prompt'] ?? null;
    $userId = $_GET['userid'] ?? $_GET['userId'] ?? null;
    $voice  = $_GET['model'] ?? null;
}

if (!$prompt || !$userId || !$voice) {
    jsonResponse(false, [], "'prompt' or 'userId', and 'model' are required");
}


if (!in_array($voice, $allowed_voices)) {
    jsonResponse(false, [], "Invalid voice model. Allowed values: " . implode(',', $allowed_voices));
}

$audioManager = new AudioManager();
$aiManager = new AIManager($config);

$aiResponse = $aiManager->generateText($userId, $prompt);

if (is_array($aiResponse) && isset($aiResponse['error'])) {
    jsonResponse(false, [], $aiResponse['error']);
}

$audioUrl = $audioManager->textToSpeech($aiResponse, $voice);

jsonResponse(true, [
    'result' => $audioUrl
]);
