<?php

class AudioManager {
    private $folder;

    public function __construct($folder = null) {
        $this->folder = $folder ?? __DIR__ . '/../media';
        if (!is_dir($this->folder)) mkdir($this->folder, 0777, true);
    }

    private function generateUuid(): string {
        return sprintf('%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
            mt_rand(0, 0xffff), mt_rand(0, 0xffff),
            mt_rand(0, 0xffff),
            mt_rand(0, 0x0fff) | 0x4000,
            mt_rand(0, 0x3fff) | 0x8000,
            mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff)
        );
    }

    public function textToSpeech(string $text, string $voice): string {
        $url = "https://www.openai.fm/api/generate";
        $postFields = ['input' => $text, 'voice' => $voice];
        $headers = [
            "Accept: */*",
            "Origin: https://www.openai.fm",
            "Referer: https://www.openai.fm/",
            "User-Agent: Mozilla/5.0"
        ];
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postFields);
        $audioData = curl_exec($ch);
        $curlError = curl_error($ch);
        curl_close($ch);
        if ($curlError) throw new Exception('cURL error: ' . $curlError);

        $filename = $this->generateUuid() . '.ogg';
        $filepath = $this->folder . '/' . $filename;
        file_put_contents($filepath, $audioData);

        $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
        $scriptPath = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/');
        $domain = $protocol . $_SERVER['HTTP_HOST'];
        return $domain . $scriptPath . '/media/' . $filename;
    }
}
