<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');

$apiKey = 'eedbc05ba060c787ab0614cad1f2e12b';
$baseUrl = 'https://api.openweathermap.org/data/2.5/';

header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    $city = $input['city'] ?? null;
    $units = $input['units'] ?? 'metric';
} else {
    $city = $_GET['city'] ?? null;
    $units = $_GET['units'] ?? 'metric';
}

if ($city) {
    $url = $baseUrl . "weather?q=" . urlencode($city) . "&appid=" . $apiKey . "&units=" . $units . "&lang=fa";
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode === 200) {
        $data = json_decode($response, true);
        
        if (isset($data['weather'][0]['icon'])) {
            $iconCode = $data['weather'][0]['icon'];
            $data['weather'][0]['icon'] = 'https://openweathermap.org/img/wn/' . $iconCode . '@2x.png';
        }
        
        date_default_timezone_set('Asia/Tehran');
        if (isset($data['dt'])) {
            $data['dt'] = date('Y-m-d H:i:s', $data['dt']);
        }
        if (isset($data['sys']['sunrise'])) {
            $data['sys']['sunrise'] = date('H:i:s', $data['sys']['sunrise']);
        }
        if (isset($data['sys']['sunset'])) {
            $data['sys']['sunset'] = date('H:i:s', $data['sys']['sunset']);
        }
        
        echo json_encode([
            'ok' => true,
            'dev' => '@OnyxApiTeam',
            'result' => $data
        ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    } else {
        $errorData = json_decode($response, true);
        $errorMessage = isset($errorData['message']) ? $errorData['message'] : 'Weather API Error';
        
        echo json_encode([
            'ok' => false,
            'dev' => '@OnyxApiTeam',
            'error' => $errorMessage
        ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    }
} else {
    echo json_encode([
        'ok' => false,
        'dev' => '@OnyxApiTeam',
        'error' => 'Missing city parameter'
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
}
?>