<?php
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json; charset=utf-8');

function fetchUrl(string $url) {
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_TIMEOUT => 10,
        CURLOPT_USERAGENT => 'Wiki-Search-API/1.0'
    ]);
    $response = curl_exec($ch);
    $err = curl_error($ch);
    curl_close($ch);
    if ($err || !$response) {
        return false;
    }
    return $response;
}

$input = $_SERVER['REQUEST_METHOD'] === 'POST'
    ? json_decode(file_get_contents('php://input'), true) ?? $_POST
    : $_GET;

$query = trim($input['q'] ?? '');
$lang = $input['lang'] ?? 'fa';

if (!$query) {
    http_response_code(400);
    echo json_encode([
        'ok' => false,
        'dev' => '@OnyxApiTeam',
        'result' => 'Missing or empty "q" parameter.'
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    exit;
}

$url = "https://$lang.wikipedia.org/api/rest_v1/page/summary/" . urlencode($query);
$data = fetchUrl($url);

if (!$data) {
    http_response_code(404);
    echo json_encode([
        'ok' => false,
        'dev' => '@OnyxApiTeam',
        'result' => 'Page not found or unable to access Wikipedia.'
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    exit;
}

$json = json_decode($data, true);
if (!isset($json['title'])) {
    http_response_code(404);
    echo json_encode([
        'ok' => false,
        'dev' => '@OnyxApiTeam',
        'result' => 'Page not found.'
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    exit;
}

echo json_encode([
    'ok' => true,
    'dev' => '@OnyxApiTeam',
    'result' => [
        'title' => $json['title'],
        'description' => $json['description'] ?? null,
        'extract' => $json['extract'] ?? null,
        'thumbnail' => $json['thumbnail']['source'] ?? null,
        'url' => $json['content_urls']['desktop']['page'] ?? null,
        'lang' => $lang
    ]
], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
