<?php

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

$dev = "@OnyxApiTeam";

$requestData = [];

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $requestData = $_GET;
} elseif ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $contentType = $_SERVER['CONTENT_TYPE'] ?? '';
    if (strpos($contentType, 'application/json') !== false) {
        $requestData = json_decode(file_get_contents('php://input'), true) ?? [];
    } else {
        $requestData = $_POST;
    }
} else {
    apiError("Method not allowed", 405, $dev);
}

$url = $requestData['url'] ?? null;
if (!$url) {
    apiError("Missing required parameter: url", 400, $dev);
}

try {
    $response = fetchYTDown($url);
    $decoded = json_decode($response, true);

    if (!$decoded || !isset($decoded['api'])) {
        apiError("Invalid upstream response", 502, $dev);
    }

    $output = brandResponse($decoded);
    apiSuccess($dev, $output);

} catch (Exception $e) {
    apiError("Internal server error", 500, $dev);
}

function fetchYTDown($videoUrl) {
    $postFields = http_build_query([
        'url' => $videoUrl
    ]);

    $ch = curl_init("https://ytdown.to/proxy.php");
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => $postFields,
        CURLOPT_HTTPHEADER => [
            "Content-Type: application/x-www-form-urlencoded; charset=UTF-8",
            "Origin: https://ytdown.to",
            "Referer: https://ytdown.to/en2/",
            "X-Requested-With: XMLHttpRequest",
            "User-Agent: Mozilla/5.0"
        ]
    ]);

    $res = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpCode !== 200 || !$res) {
        throw new Exception("Upstream error");
    }

    return $res;
}

function brandResponse($data) {
    $api = $data['api'] ?? [];

    $userInfo = $api['userInfo'] ?? [];
    $user = [
        'name' => $userInfo['name'] ?? '',
        'username' => $userInfo['username'] ?? '',
        'avatar' => $userInfo['userAvatar'] ?? '',
        'bio' => $userInfo['userBio'] ?? '',
        'joined' => $userInfo['dateJoined'] ?? '',
        'verified' => (bool)($userInfo['isVerified'] ?? false)
    ];

    $mediaStats = $api['mediaStats'] ?? [];
    $stats = [
        'mediaCount' => $mediaStats['mediaCount'] ?? 0,
        'followersCount' => $mediaStats['followersCount'] ?? 0,
        'viewsCount' => $mediaStats['viewsCount'] ?? 0
    ];

    $items = [];
    foreach ($api['mediaItems'] ?? [] as $item) {
        $items[] = [
            'type' => $item['type'] ?? '',
            'name' => $item['name'] ?? '',
            'url' => $item['mediaUrl'] ?? '',
            'mediaPreviewUrl' => $item['mediaPreviewUrl'] ?? '',
            'resolution' => $item['mediaRes'] ?? '',
            'quality' => $item['mediaQuality'] ?? '',
            'duration' => $item['mediaDuration'] ?? '',
            'extension' => $item['mediaExtension'] ?? '',
            'size' => $item['mediaFileSize'] ?? ''
        ];
    }

    return [
        'info' => [
            'id' => $api['id'] ?? '',
            'title' => $api['title'] ?? '',
            'description' => $api['description'] ?? '',
            'imagePreviewUrl' => $api['imagePreviewUrl'] ?? '',
            'permanentLink' => $api['permanentLink'] ?? ''
        ],
        'user' => $user,
        'stats' => $stats,
        'mediaItems' => $items
    ];
}

function apiSuccess($dev, $data) {
    echo json_encode([
        'ok' => true,
        'dev' => $dev,
        'data' => $data
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    exit;
}

function apiError($error, $status = 400, $dev = null) {
    http_response_code($status);
    echo json_encode([
        'ok' => false,
        'dev' => $dev,
        'error' => $error
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    exit;
}
